/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.tsd;

import com.ibm.hwmca.base.tsd.TransmitSvcDataUtils;
import com.ibm.hwmca.base.tsd.TsdEntryData;
import com.ibm.hwmca.base.tsd.TsdErrorIds;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.util.FileUtilities;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class TsdEntryDataParser
implements TsdErrorIds {
    public static final String XML_FILENAME = "acustsd.xml";
    public static final String XML_FILE_PATTERN = "acustsd*.xml";
    private static final String TRACEMASK_T = "XTSDPSRT";
    private static final String TRACEMASK_F = "XTSDPSRF";
    private static final String TRACEMASK_D = "XTSDPSRD";
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(-44, "TsdXmlParser");
    private List dataList;
    private String xml_filename;
    private String source_filename;
    private String resFileName;
    private String utilClassName;
    private boolean utilClassSet = false;
    private TransmitSvcDataUtils utils = null;
    private Class className;
    private static String file_path;

    public TsdEntryDataParser(String xml_filename, List list) throws HException {
        Trace.trace(TRACEMASK_T, "<--> TsdEntryDataParser(" + xml_filename + ")");
        this.dataList = list;
        this.source_filename = xml_filename;
        this.xml_filename = file_path + xml_filename;
    }

    public static List parseTsdData() {
        Trace.trace(TRACEMASK_T, "--> parseTsdData()");
        Vector entryList = new Vector();
        try {
            file_path = BaseFileControl.getFilePath(XML_FILENAME);
            ArrayList fileList = FileUtilities.getFileList(file_path, XML_FILE_PATTERN, true);
            Iterator files = fileList.iterator();
            while (files.hasNext()) {
                TsdEntryDataParser parser = new TsdEntryDataParser((String)files.next(), entryList);
                parser.doParse();
            }
            Trace.trace(TRACEMASK_T, "<-- parseTsdData()");
            return entryList;
        }
        catch (HException hEx) {
            Trace.trace(TRACEMASK_T, "HException caught!  Error logged and returning NULL!");
            new FrameworkLog(logInfo, 20581, hEx).log();
            return entryList;
        }
    }

    public void doParse() {
        SAXParser parser = null;
        TsdEntryDataParserHandler handler = null;
        try {
            handler = new TsdEntryDataParserHandler();
            parser = new SAXParser();
            parser.setContentHandler((ContentHandler)handler);
            parser.setErrorHandler((ErrorHandler)handler);
            parser.parse(new InputSource(new FileReader(this.xml_filename)));
        }
        catch (SAXException saxEx) {
            Trace.trace(TRACEMASK_T, "SAXException caught!  Error logged and returning NULL!");
            new FrameworkLog(logInfo, 20582, saxEx).log();
            return;
        }
        catch (FileNotFoundException fnfEx) {
            Trace.trace(TRACEMASK_T, "FileNotFoundException caught!  Error logged and returning NULL!");
            new FrameworkLog(logInfo, 20581, fnfEx).log();
            return;
        }
        catch (IOException ioEx) {
            Trace.trace(TRACEMASK_T, "IOException caught!  Error logged and returning NULL!");
            new FrameworkLog(logInfo, 20581, ioEx).log();
            return;
        }
        catch (Exception ex) {
            Trace.trace(TRACEMASK_T, "Exception caught!  Error logged and returning NULL!");
            new FrameworkLog(logInfo, 20582, ex).log();
            return;
        }
    }

    private class TsdEntryDataParserHandler
    extends DefaultHandler {
        static final String CLASSDEF_TAG = "ClassDef";
        static final String CLASSDEF_ETAG = "/ClassDef";
        static final String UTILCLASS_TAG = "util_class";
        static final String UTILCLASS_ETAG = "/util_class";
        static final String LISTELEMENTS_TAG = "ListElements";
        static final String LISTELEMENTS_ETAG = "/ListElements";
        static final String RESFILE_TAG = "res_file";
        static final String RESFILE_ETAG = "/res_file";
        static final String TSDLIST_TAG = "TSDList";
        static final String TSDLIST_ETAG = "/TSDList";
        static final String TSD_TAG = "TSD";
        static final String TSD_ETAG = "/TSD";
        static final String RETAIN_TAG = "retain_flag";
        static final String RETAIN_ETAG = "/retain_flag";
        static final String DISK_TAG = "diskette_flag";
        static final String DISK_ETAG = "/diskette_flag";
        static final String DVD_TAG = "dvd_flag";
        static final String DVD_ETAG = "/dvd_flag";
        static final String DTYPE_TAG = "data_type";
        static final String DTYPE_ETAG = "/data_type";
        static final String FNAME_TAG = "file_name";
        static final String FNAME_ETAG = "/file_name";
        static final String MSGNUM_TAG = "message_number";
        static final String MSGNUM_ETAG = "/message_number";
        static final String PNAME_TAG = "program_name";
        static final String PNAME_ETAG = "/program_name";
        static final String FILEAV_TAG = "file_availability";
        static final String FILEAV_ETAG = "/file_availability";
        private FiniteStateMachine fsm;
        private Hashtable filesChecked;
        private TsdEntryData data;

        TsdEntryDataParserHandler() throws IOException {
            Trace.trace(TsdEntryDataParser.TRACEMASK_T, "<-> TsdEntryDataParserHandler()");
            this.filesChecked = new Hashtable();
        }

        public void startElement(String uri, String name, String qName, Attributes atts) {
            if (qName.equals(TSDLIST_TAG)) {
                this.fsm = new FiniteStateMachine();
            } else {
                if (qName.equals(TSD_TAG)) {
                    this.data = new TsdEntryData();
                }
                this.fsm.advanceState(qName);
            }
        }

        public void endElement(String uri, String name, String qName) {
            qName = "/" + qName;
            this.fsm.advanceState(qName);
            if (qName.equals(TSD_ETAG)) {
                if (!TsdEntryDataParser.this.utilClassSet) {
                    try {
                        this.data.setTsdUtilObject(TsdEntryDataParser.this.utilClassName);
                    }
                    catch (Exception e) {
                        Trace.trace(TsdEntryDataParser.TRACEMASK_F, "TsdEntryDataParser: unable to make TransmitSvcDataUtils object for" + TsdEntryDataParser.this.utilClassName);
                        Trace.trace(TsdEntryDataParser.TRACEMASK_F, e);
                        FrameworkLog log = new FrameworkLog(logInfo, 20593, e);
                        log.add("Invalid TransmitSvcDataUtils object: " + TsdEntryDataParser.this.utilClassName);
                        log.log();
                    }
                    TsdEntryDataParser.this.utils = this.data.getTsdUtilObject();
                    TsdEntryDataParser.this.utilClassSet = true;
                } else {
                    this.data.setTsdUtilObject(TsdEntryDataParser.this.utils);
                }
                this.data.setResPath(TsdEntryDataParser.this.resFileName);
                Trace.trace(TsdEntryDataParser.TRACEMASK_F, "TsdEntryDataParser element:" + this.data.toString());
                TsdEntryDataParser.this.dataList.add(this.data);
                this.data = null;
            }
        }

        public void characters(char[] pcdata, int start, int length) throws SAXException {
            byte dataType = 0;
            String str = null;
            str = new String(pcdata, start, length);
            try {
                switch (this.fsm.getState()) {
                    case 22: {
                        TsdEntryDataParser.this.utilClassName = str;
                        break;
                    }
                    case 24: {
                        TsdEntryDataParser.this.resFileName = str;
                        break;
                    }
                    case 4: {
                        this.data.setRetainFlag(Integer.parseInt(str) == 1);
                        break;
                    }
                    case 6: {
                        this.data.setDisketteFlag(Integer.parseInt(str) == 1);
                        break;
                    }
                    case 8: {
                        this.data.setDvdFlag(Integer.parseInt(str) == 1);
                        break;
                    }
                    case 10: {
                        dataType = Byte.parseByte(str);
                        this.data.setDataType(dataType);
                        if (dataType != 2 && dataType != 3) break;
                        this.data.setFileAvailFlag(true);
                        break;
                    }
                    case 12: {
                        this.data.setFileName(BaseFileControl.getFilePath(str) + str);
                        break;
                    }
                    case 14: {
                        this.data.setMessageNumber(Short.parseShort(str));
                        break;
                    }
                    case 16: {
                        this.data.setProgramName(str);
                        break;
                    }
                    case 18: {
                        if (this.filesChecked.containsKey(str)) {
                            this.data.setFileAvailFlag((Boolean)this.filesChecked.get(str));
                            break;
                        }
                        Boolean fileAv = new Boolean(this.isFileAvailable(str));
                        this.filesChecked.put(str, fileAv);
                        this.data.setFileAvailFlag(fileAv);
                    }
                }
            }
            catch (HException hEx) {
                throw new SAXException(hEx);
            }
        }

        public void warning(SAXParseException saxpEx) {
            Trace.trace(TsdEntryDataParser.TRACEMASK_T, "Parser warning found and logged!  Parsing will continue.");
            new FrameworkLog(logInfo, 20582, saxpEx).log();
        }

        public void error(SAXParseException saxpEx) {
            Trace.trace(TsdEntryDataParser.TRACEMASK_T, "Parser error found and logged!  Parsing will continue.");
            new FrameworkLog(logInfo, 20582, saxpEx).log();
        }

        public void fatalError(SAXParseException saxpEx) throws SAXException {
            Trace.trace(TsdEntryDataParser.TRACEMASK_T, "Parser error found!  Parsing can not continue!  SAXException being thrown...");
            throw new SAXException(saxpEx);
        }

        private boolean isFileAvailable(String fileName) throws HException {
            char[] filechars = this.eliminateRedundantStars(fileName.toCharArray());
            String[] filenames = new File(BaseFileControl.getFilePath(fileName)).list();
            int i = 0;
            while (i < filenames.length) {
                if (this.isMatch(filechars, 0, filenames[i].toCharArray(), 0)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private boolean isMatch(char[] file1, int start1, char[] file2, int start2) {
            boolean noCharsLeft2;
            boolean noCharsLeft1 = file1.length - start1 == 0;
            boolean bl = noCharsLeft2 = file2.length - start2 == 0;
            if (file1.length - start1 == 1 && file1[start1] == '*') {
                return true;
            }
            if (noCharsLeft1 && noCharsLeft2) {
                return true;
            }
            if (noCharsLeft1 || noCharsLeft2) {
                return false;
            }
            if (file1[start1] == '*') {
                int[] indices = this.getAllIndices(file2, start2, file1[start1 + 1]);
                boolean foundMatch = false;
                int i = 0;
                while (i < indices.length && !foundMatch) {
                    foundMatch = this.isMatch(file1, start1 + 1, file2, indices[i]);
                    ++i;
                }
                return foundMatch;
            }
            if (file1[start1] == '?' || file1[start1] == file2[start2]) {
                return this.isMatch(file1, start1 + 1, file2, start2 + 1);
            }
            return false;
        }

        private char[] eliminateRedundantStars(char[] chars) {
            boolean lastCharWasStar = false;
            StringBuffer newChars = new StringBuffer();
            int i = 0;
            while (i < chars.length) {
                if (!lastCharWasStar || chars[i] != '*') {
                    newChars.append(chars[i]);
                    lastCharWasStar = chars[i] == '*';
                }
                ++i;
            }
            return newChars.toString().toCharArray();
        }

        private int[] getAllIndices(char[] chars, int start, char ch) {
            int[] indices = null;
            Vector<Integer> vIndices = new Vector<Integer>();
            int i = start;
            while (i < chars.length) {
                if (ch == '?' || chars[i] == ch) {
                    vIndices.add(new Integer(i));
                }
                ++i;
            }
            indices = new int[vIndices.size()];
            int i2 = 0;
            while (i2 < indices.length) {
                indices[i2] = (Integer)vIndices.get(i2);
                ++i2;
            }
            return indices;
        }

        private class FiniteStateMachine {
            static final byte TSDLIST = 0;
            static final byte _TSDLIST = 1;
            static final byte TSD = 2;
            static final byte _TSD = 3;
            static final byte RETAIN = 4;
            static final byte _RETAIN = 5;
            static final byte DISK = 6;
            static final byte _DISK = 7;
            static final byte DVD = 8;
            static final byte _DVD = 9;
            static final byte DTYPE = 10;
            static final byte _DTYPE = 11;
            static final byte FNAME = 12;
            static final byte _FNAME = 13;
            static final byte MSGNUM = 14;
            static final byte _MSGNUM = 15;
            static final byte PNAME = 16;
            static final byte _PNAME = 17;
            static final byte FILEAV = 18;
            static final byte _FILEAV = 19;
            static final byte CLASSDEF = 20;
            static final byte _CLASSDEF = 21;
            static final byte UTILCLASS = 22;
            static final byte _UTILCLASS = 23;
            static final byte RESFILE = 24;
            static final byte _RESFILE = 25;
            static final byte LISTELEMENTS = 26;
            static final byte _LISTELEMENTS = 27;
            private int state = 0;

            FiniteStateMachine() {
            }

            void advanceState(String tagName) {
                switch (this.state) {
                    case 0: {
                        if (!tagName.equals(TsdEntryDataParserHandler.CLASSDEF_TAG)) break;
                        this.state = 20;
                        break;
                    }
                    case 20: {
                        if (!tagName.equals(TsdEntryDataParserHandler.UTILCLASS_TAG)) break;
                        this.state = 22;
                        break;
                    }
                    case 22: {
                        if (!tagName.equals(TsdEntryDataParserHandler.UTILCLASS_ETAG)) break;
                        this.state = 23;
                        break;
                    }
                    case 23: {
                        if (!tagName.equals(TsdEntryDataParserHandler.RESFILE_TAG)) break;
                        this.state = 24;
                        break;
                    }
                    case 24: {
                        if (!tagName.equals(TsdEntryDataParserHandler.RESFILE_ETAG)) break;
                        this.state = 25;
                        break;
                    }
                    case 25: {
                        if (!tagName.equals(TsdEntryDataParserHandler.CLASSDEF_ETAG)) break;
                        this.state = 21;
                        break;
                    }
                    case 21: {
                        if (!tagName.equals(TsdEntryDataParserHandler.LISTELEMENTS_TAG)) break;
                        this.state = 26;
                        break;
                    }
                    case 27: {
                        if (!tagName.equals(TsdEntryDataParserHandler.TSDLIST_ETAG)) break;
                        this.state = 1;
                        break;
                    }
                    case 3: 
                    case 26: {
                        if (tagName.equals(TsdEntryDataParserHandler.TSD_TAG)) {
                            this.state = 2;
                            break;
                        }
                        if (!tagName.equals(TsdEntryDataParserHandler.LISTELEMENTS_ETAG)) break;
                        this.state = 27;
                        break;
                    }
                    case 2: {
                        if (!tagName.equals(TsdEntryDataParserHandler.RETAIN_TAG)) break;
                        this.state = 4;
                        break;
                    }
                    case 4: {
                        if (!tagName.equals(TsdEntryDataParserHandler.RETAIN_ETAG)) break;
                        this.state = 5;
                        break;
                    }
                    case 5: {
                        if (!tagName.equals(TsdEntryDataParserHandler.DISK_TAG)) break;
                        this.state = 6;
                        break;
                    }
                    case 6: {
                        if (!tagName.equals(TsdEntryDataParserHandler.DISK_ETAG)) break;
                        this.state = 7;
                        break;
                    }
                    case 7: {
                        if (!tagName.equals(TsdEntryDataParserHandler.DVD_TAG)) break;
                        this.state = 8;
                        break;
                    }
                    case 8: {
                        if (!tagName.equals(TsdEntryDataParserHandler.DVD_ETAG)) break;
                        this.state = 9;
                        break;
                    }
                    case 9: {
                        if (!tagName.equals(TsdEntryDataParserHandler.DTYPE_TAG)) break;
                        this.state = 10;
                        break;
                    }
                    case 10: {
                        if (!tagName.equals(TsdEntryDataParserHandler.DTYPE_ETAG)) break;
                        this.state = 11;
                        break;
                    }
                    case 11: {
                        if (!tagName.equals(TsdEntryDataParserHandler.FNAME_TAG)) break;
                        this.state = 12;
                        break;
                    }
                    case 12: {
                        if (!tagName.equals(TsdEntryDataParserHandler.FNAME_ETAG)) break;
                        this.state = 13;
                        break;
                    }
                    case 13: {
                        if (!tagName.equals(TsdEntryDataParserHandler.MSGNUM_TAG)) break;
                        this.state = 14;
                        break;
                    }
                    case 14: {
                        if (!tagName.equals(TsdEntryDataParserHandler.MSGNUM_ETAG)) break;
                        this.state = 15;
                        break;
                    }
                    case 15: {
                        if (tagName.equals(TsdEntryDataParserHandler.PNAME_TAG)) {
                            this.state = 16;
                            break;
                        }
                        if (tagName.equals(TsdEntryDataParserHandler.FILEAV_TAG)) {
                            this.state = 18;
                            break;
                        }
                        if (!tagName.equals(TsdEntryDataParserHandler.TSD_ETAG)) break;
                        this.state = 3;
                        break;
                    }
                    case 16: {
                        if (!tagName.equals(TsdEntryDataParserHandler.PNAME_ETAG)) break;
                        this.state = 17;
                        break;
                    }
                    case 17: {
                        if (tagName.equals(TsdEntryDataParserHandler.FILEAV_TAG)) {
                            this.state = 18;
                            break;
                        }
                        if (!tagName.equals(TsdEntryDataParserHandler.TSD_ETAG)) break;
                        this.state = 3;
                        break;
                    }
                    case 18: {
                        if (!tagName.equals(TsdEntryDataParserHandler.FILEAV_ETAG)) break;
                        this.state = 19;
                        break;
                    }
                    case 19: {
                        if (!tagName.equals(TsdEntryDataParserHandler.TSD_ETAG)) break;
                        this.state = 3;
                    }
                }
            }

            int getState() {
                return this.state;
            }
        }
    }
}

